/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.builder;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.sequence.RichSequence;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;

public final class RichSequenceBuilder
implements ISequenceBuilder<RichSequenceBuilder, RichSequence> {
    private final StringBuilder segments;

    @NotNull
    public static RichSequenceBuilder emptyBuilder() {
        return new RichSequenceBuilder();
    }

    private RichSequenceBuilder() {
        this.segments = new StringBuilder();
    }

    public RichSequenceBuilder(int initialCapacity) {
        this.segments = new StringBuilder(initialCapacity);
    }

    @Override
    @NotNull
    public RichSequenceBuilder getBuilder() {
        return new RichSequenceBuilder();
    }

    @Override
    public char charAt(int index) {
        return this.segments.charAt(index);
    }

    @Override
    @NotNull
    public RichSequenceBuilder append(@Nullable CharSequence chars, int startIndex, int endIndex) {
        if (chars != null && chars.length() > 0 && startIndex < endIndex) {
            this.segments.append(chars, startIndex, endIndex);
        }
        return this;
    }

    @Override
    @NotNull
    public RichSequenceBuilder append(char c) {
        this.segments.append(c);
        return this;
    }

    @Override
    @NotNull
    public RichSequenceBuilder append(char c, int count) {
        while (count-- > 0) {
            this.segments.append(c);
        }
        return this;
    }

    @Override
    @NotNull
    public RichSequence getSingleBasedSequence() {
        return this.toSequence();
    }

    @Override
    @NotNull
    public RichSequence toSequence() {
        return RichSequence.of(this.segments);
    }

    @Override
    public int length() {
        return this.segments.length();
    }

    public String toString() {
        return this.segments.toString();
    }
}

